/*
 * This class holds all the special ID's
 * that are scheduled
 */

package creeksidescheduler;

public class Schedule {

    private final int DAYS = 5; //Days in a week
    private final int HOURS = 6; //Hours in a day
    private final int MINUTES= 30; //Partial minutes
    private final int TBLOCK= 5;//Size of time block in minutes
    private final int[] TIME_INFO= {9,0,TBLOCK};//Start Time of the day with time blocks: H,M,TBLOCK
    private String Owner;//classroom
    private int timeslots;
    private int[][] Sched;

    public void Schedule(){
    }

    //creates an empty schedule
    public void createSched(){
        timeslots=(HOURS*60+MINUTES)/TBLOCK;
        Sched = new int[DAYS][timeslots];
        for(int d=0;d<DAYS;d++){
            for(int h=0;h<timeslots;h++){
                Sched[d][h]=0;
            }
        }
        Owner=null;
    }

    //return the whole schedule
    public int[][] getSchedule(){
        return Sched;
    }

    //set owner
    public void setOwner(String classroom){
        Owner = classroom;
    }

    //get owner
    public String getOwner(){
        return Owner;
    }

    //get Time Settings
    public int[] getTimeInfo(){
        return TIME_INFO;
    }

    //get maximun number of days per week
    public int getMaxDays(){
        return DAYS;
    }

    //return a specific day
    public int[] getDay(int day){
        int[]badRequest=new int[0];
        if (day>=0&&day<DAYS){
            return Sched[day];
        }
        else{
            return badRequest;
        }
    }

    //adds a special specific time slots
    public boolean checkIfOpen(int day, int start, int end, int ID){
        if (!isValidTimeSlot(day,start,end-1)){
            return false;
        }
        for (int x=start;x<end;x++){
            if (getTimeSlot(day, x)!=0){
                if (getTimeSlot(day, x)!=ID){
                    return false;
                }
            }
        }
        return true;
    }

    //return a specific time slot. returns -1 for an error.
    public int getTimeSlot(int day, int requested_slot){
        int special = -1;
        if (requested_slot>=0&&requested_slot<timeslots){
            special = Sched[day][requested_slot];
        }
        return special;
    }

    //checks the whole schedule and removes
    //a special
    public boolean remSpecialFromSchedule(Special spec){
        boolean found=false;

        for (int day=0;day<DAYS;day++){
            for(int slot=0;slot<timeslots;slot++){
                if(Sched[day][slot]==spec.getID()){
                    found=true;
                    Sched[day][slot]=0;
                }
            }
        }

        return found;
    }
    //Clears out schedule slots
    public boolean remSlotFromSchedule(int day, int start, int end){
        if (!isValidTimeSlot(day,start,end)){
            return false;
        }
        for (int x=start;x<=end;x++){
            changeSlot(0,day,x);
        }
        return true;
    }

    //adds a special specific time slots
    public boolean addToSchedule(int Special, int day, int start, int end){
        if (!isValidTimeSlot(day,start,end-1)){
            return false;
        }
        if (Special<1){
            return false;
        }
        for (int x=start;x<end;x++){
            changeSlot(Special,day,x);
        }
        return true;
    }

    //Puts the Special number into a slot
    private void changeSlot(int Special, int day, int slot){
        Sched[day][slot]=Special;
    }

    //Checks to see if requested time info is valid
    private boolean isValidTimeSlot (int day, int start, int end){
        if (day<0||day>=DAYS){
            return false;
        }
        if (start > end){
            return false;
        }
        return true;
    }
}
